// Based on the wood shader in the Orange Book

varying vec4 rawpos;
varying vec4 texCoord;

uniform float scale;
uniform sampler2D s_tex0;

// This function takes a value between -1 and 1, and moves it to between 0 and 1
float unsign(float x) {
	return x * 0.5 + 0.5;
}

/*
 * To create offsets of one texel and one half texel in the
 * texture lookup, we need to know the texture image size.
 */
//#define ONE 0.00390625
const float ONEHALF = 0.5/256.0;
const float ONE = 1.0/256.0;

//#define ONE 0.00390625
//#define ONEHALF 0.001953125
// The numbers above are 1/256 and 0.5/256, change accordingly
// if you change the code to use another texture size.


/*
 * The interpolation function. This could be a 1D texture lookup
 * to get some more speed, but it's not the main part of the algorithm.
 */
float fade(float t) {
  return t*t*t*(t*(t*6.0-15.0)+10.0); // Improved fade, yields C2-continuous noise
}

/*
 * 2D classic Perlin noise. Fast, but less useful than 3D noise.
 */
float noise(vec2 P)
{
  vec2 Pi = ONE*floor(P)+ONEHALF; // Integer part, scaled and offset for texture lookup
  vec2 Pf = fract(P);             // Fractional part for interpolation

  // Noise contribution from lower left corner
  vec2 grad00 = texture2D(s_tex0, Pi).rg * 4.0 - 1.0;
  float n00 = dot(grad00, Pf);

  // Noise contribution from lower right corner
  vec2 grad10 = texture2D(s_tex0, Pi + vec2(ONE, 0.0)).rg * 4.0 - 1.0;
  float n10 = dot(grad10, Pf - vec2(1.0, 0.0));

  // Noise contribution from upper left corner
  vec2 grad01 = texture2D(s_tex0, Pi + vec2(0.0, ONE)).rg * 4.0 - 1.0;
  float n01 = dot(grad01, Pf - vec2(0.0, 1.0));

  // Noise contribution from upper right corner
  vec2 grad11 = texture2D(s_tex0, Pi + vec2(ONE, ONE)).rg * 4.0 - 1.0;
  float n11 = dot(grad11, Pf - vec2(1.0, 1.0));

  // Blend contributions along x
  vec2 n_x = mix(vec2(n00, n01), vec2(n10, n11), fade(Pf.x));

  // Blend contributions along y
  float n_xy = mix(n_x.x, n_x.y, fade(Pf.y));

  // We're done, return the final noise value.
  return n_xy;
}

void main() {

	vec3 LightWood = vec3(0.52, 0.32, 0.2);
	vec3 DarkWood = vec3(0.21, 0.1, 0.1);
//	float RingFreq = 4.9;
	float LightGrains = 0.01;
	float DarkGrains = 0.08;
	float GrainThreshold = 0.3;
	vec2 NoiseScale= vec2(0.1, 0.8);
	float Noisiness = 9.4;
	float GrainScale = 40.0;

	vec4 color;
									// be negated, but it does.
	float scalelocal = 0.1 + scale * 2.0;

	vec4 tp = texCoord * scalelocal;
	vec2 rp = rawpos.xy * scalelocal * NoiseScale;
	
	vec2 noisevec = vec2(noise(rp), noise(rp*3.3)) * Noisiness;
	vec2 location = rp + noisevec;
	
	float rf = sqrt( location.x * location.x + location.y * location.y );
//	rf *= RingFreq;
	
	float ribs = rf - fract(rp.y * GrainScale +0.5);
	float grains = rf - floor(rf+0.5);

	rf = mix(ribs, grains, 0.7);

	color = vec4(mix(LightWood, DarkWood, rf), 1.0);

	color.xyz += mix(LightWood * LightGrains * unsign(noisevec[0]), 
				  -LightWood * DarkGrains * unsign(noisevec[0]),
				   abs(GrainThreshold-rf));
	
//	float intensity = min(1.0, noise(rp) * 5.0);
//	color = vec4(intensity, intensity, intensity, 1.0);
	
//	vec4 tx = texture2D(theTex, texCoord.xy);
//	gl_FragColor = tx;

//	gl_FragColor = vec4(texCoord[0], texCoord[1], 1.0, 1.0);
//	gl_FragColor = vec4(noisevec[0], noisevec[1], 0.0, 1.0);
	gl_FragColor = color;

}

